//
// This file contains a 'Sample Driver' and is licensed as such
// under the terms of your license agreement with Intel or your
// vendor.  This file may be modified by the user, subject to
// the additional terms of the license agreement
//
/** @file
  Header file for UserAuthenticationDxe.

  Copyright (c) 2017, Intel Corporation. All rights reserved.<BR>
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by such
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.

**/

#ifndef _USER_AUTHENTICATION_DXE_H_
#define _USER_AUTHENTICATION_DXE_H_


#include <Protocol/ReportStatusCodeHandler.h>
#include <Protocol/HiiConfigAccess.h>
#include <Protocol/SmmCommunication.h>

#include <Guid/MdeModuleHii.h>
#include <Guid/HiiPlatformSetupFormset.h>
#include <Guid/PiSmmCommunicationRegionTable.h>

#include <Library/PrintLib.h>
#include <Library/DebugLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/UefiRuntimeServicesTableLib.h>
#include <Library/UefiDriverEntryPoint.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/BaseLib.h>
#include <Library/UefiLib.h>
#include <Library/HiiLib.h>
#include <Library/DevicePathLib.h>
#include <Library/MemoryAllocationLib.h>
//#include <Library/PlatformPasswordLib.h>
#include "UserAuthenticationGuid.h"
#include "UserAuthenticationDxeFormset.h"

extern UINT8  UserAuthenticationDxeVfrBin[];
extern UINT8  UserAuthenticationDxeStrings[];
extern EFI_SMM_COMMUNICATION_PROTOCOL *mSmmCommunication;

typedef struct {
  EFI_HII_CONFIG_ACCESS_PROTOCOL       ConfigAccess;
  EFI_HANDLE                           DriverHandle;
  EFI_HII_HANDLE                       HiiHandle;
  UINT8                                PasswordState;
  CHAR16                               OldPassword[PASSWORD_MAX_SIZE];
} USER_AUTHENTICATION_PRIVATE_DATA;

#pragma pack(1)
///
/// HII specific Vendor Device Path definition.
///
typedef struct {
  VENDOR_DEVICE_PATH             VendorDevicePath;
  EFI_DEVICE_PATH_PROTOCOL       End;
} HII_VENDOR_DEVICE_PATH;
#pragma pack()

/**
  Validata if the password is correct.

  @param[in]  UserGuid               The user GUID of the password.
  @param[in]  Password               The user input password.
  @param[in]  PasswordSize           The size of Password in byte.

  @retval EFI_SUCCESS              The password is correct.
  @retval EFI_SECURITY_VIOLATION   The password is incorrect.
**/
EFI_STATUS
ValidatePassword (
  IN   EFI_GUID     *UserGuid,
  IN   CHAR16       *Password,
  IN   UINTN        PasswordSize
  );

/**
  Set a new password.

  @param[in]  UserGuid               The user GUID of the password.
  @param[in]  NewPassword            The user input new password.
                                     NULL means clear password.
  @param[in]  NewPasswordSize        The size of NewPassword in byte.
  @param[in]  OldPassword            The user input old password.
                                     NULL means no old password.
  @param[in]  OldPasswordSize        The size of OldPassword in byte.

  @retval EFI_SUCCESS              The password is correct.
  @retval EFI_SECURITY_VIOLATION   The password is incorrect.
  @retval EFI_OUT_OF_RESOURCES     Insufficient resources to set the password.
**/
EFI_STATUS
SetPassword (
  IN   EFI_GUID     *UserGuid,
  IN   CHAR16       *NewPassword,     OPTIONAL
  IN   UINTN        NewPasswordSize,
  IN   CHAR16       *OldPassword,     OPTIONAL
  IN   UINTN        OldPasswordSize
  );

/**
  Return if the password is set.

  @param[in]  UserGuid               The user GUID of the password.

  @retval TRUE    The password is set.
  @retval FALSE   The password is not set.
**/
BOOLEAN
IsPasswordSet (
  IN   EFI_GUID     *UserGuid
  );

#endif
